(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16655,        298]*)
(*NotebookOutlinePosition[     17500,        325]*)
(*  CellTagsIndexPosition[     17456,        321]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Exact\ p[
            x] = \(\((1 - 
                  x)\)^\((\(-0.34\))\)*\((1 + 
                    x)\)^\((\(-0.66\))\) . \[IndentingNewLine]This\ means\ \
exact\ g[x] = \(1\ \[IndentingNewLine]For\ this\ problem\ a = 
            cot[\((\[Alpha] + 1)\) \[Pi]]\)\), \ 
      and\ b = \(-1\), \[IndentingNewLine]a = \(Cot[\((\[Alpha] + 
                  1)\)\ \[Pi]] = \(Cot[
              0.66\ \[Pi]] = \ \(-0.5497546521927703`\)\)\)*) \
\[IndentingNewLine]pexact[
        x_] := \((1 - x)\)^\((\(-0.34\))\)*\((1 + x)\)^\((\(-0.66\))\); 
    s[1] = 0.99570161;\), "\[IndentingNewLine]", 
    \(\(s[2] = 0.96919398;\)\), "\[IndentingNewLine]", 
    \(\(s[3] = 0.91882847;\)\), "\[IndentingNewLine]", 
    \(\(s[4] = 0.84583484;\)\), "\[IndentingNewLine]", 
    \(\(s[5] = 0.75200941;\)\), "\[IndentingNewLine]", 
    \(\(s[6] = 0.63966222;\)\), "\[IndentingNewLine]", 
    \(\(s[7] = 0.51155956;\)\), "\[IndentingNewLine]", 
    \(\(s[8] = 0.37085573;\)\), "\[IndentingNewLine]", 
    \(\(s[9] = 0.22101530;\)\), "\[IndentingNewLine]", 
    \(\(s[10] = 0.06572782;\)\), "\[IndentingNewLine]", 
    \(\(s[11] = \(-0.09118299\);\)\), "\[IndentingNewLine]", 
    \(\(s[12] = \(-0.24585350\);\)\), "\[IndentingNewLine]", 
    \(\(s[13] = \(-0.39447517\);\)\), "\[IndentingNewLine]", 
    \(\(s[14] = \(-0.53338846\);\)\), "\[IndentingNewLine]", 
    \(\(s[15] = \(-0.65917283\);\)\), "\[IndentingNewLine]", 
    \(\(s[16] = \(-0.76873102\);\)\), "\[IndentingNewLine]", 
    \(\(s[17] = \(-0.85936525\);\)\), "\[IndentingNewLine]", 
    \(\(s[18] = \(-0.92884347\);\)\), "\[IndentingNewLine]", 
    \(\(s[19] = \(-0.97545332\);\)\), "\[IndentingNewLine]", 
    \(\(s[20] = \(-0.99802548\);\)\), "\[IndentingNewLine]", 
    \(\(x[1] = 0.98941625;\)\), "\[IndentingNewLine]", 
    \(\(x[2] = 0.95469739;\)\), "\[IndentingNewLine]", 
    \(\(x[3] = 0.89647074;\)\), "\[IndentingNewLine]", 
    \(\(x[4] = 0.81616593;\)\), "\[IndentingNewLine]", 
    \(\(x[5] = 0.71575974;\)\), "\[IndentingNewLine]", 
    \(\(x[6] = 0.59772435;\)\), "\[IndentingNewLine]", 
    \(\(x[7] = 0.46496613;\)\), "\[IndentingNewLine]", 
    \(\(x[8] = 0.32075402;\)\), "\[IndentingNewLine]", 
    \(\(x[9] = 0.16863897;\)\), "\[IndentingNewLine]", 
    \(\(x[10] = 0.01236655;\)\), "\[IndentingNewLine]", 
    \(\(x[11] = \(-0.14421527\);\)\), "\[IndentingNewLine]", 
    \(\(x[12] = \(-0.29725094\);\)\), "\[IndentingNewLine]", 
    \(\(x[13] = \(-0.44297222\);\)\), "\[IndentingNewLine]", 
    \(\(x[14] = \(-0.57779094\);\)\), "\[IndentingNewLine]", 
    \(\(x[15] = \(-0.69838740\);\)\), "\[IndentingNewLine]", 
    \(\(x[16] = \(-0.80179206\);\)\), "\[IndentingNewLine]", 
    \(\(x[17] = \(-0.88545862\);\)\), "\[IndentingNewLine]", 
    \(\(x[18] = \(-0.94732641\);\)\), "\[IndentingNewLine]", 
    \(\(x[19] = \(-0.98586873\);\)\), "\[IndentingNewLine]", 
    \(\(x[20] = 0.876306;\)\), "\[IndentingNewLine]", 
    \(\(A[i_, j_] := \(-0.5497546521927703`\)*\ 
          2\ *\((1 - 
                s[j])\)/\((41\ \((s[j] - 
                    x[i])\))\);\)\), "\[IndentingNewLine]", 
    \(\(\(m\)\(=\)\(Table[
        A[i, j], \ {i, 20}, \ {j, 20}]\)\(\ \)\)\)}], "Input"],

Cell[BoxData[
    \({{\(-0.018339636012380197`\), 0.04085269771599073`, 
        0.030838217041979005`, 0.028794071333873825`, 0.02801283263672254`, 
        0.027628806410428825`, 0.02741125977300379`, 0.027276151894024932`, 
        0.027186674455092277`, 0.027124576446895487`, 0.027079957704250042`, 
        0.027047069839451647`, 0.02702239394301629`, 0.02700368487327307`, 
        0.026989464052152665`, 0.02697873573004909`, 0.026970821547982225`, 
        0.026965261093189506`, 0.02696175122185804`, 
        0.026960110633543758`}, {\(-0.002811203690907283`\), \
\(-0.05698818021625399`\), 0.06068767278611862`, 0.03797718647742668`, 
        0.03281121098415982`, 0.030673674898384577`, 0.029558870800666555`, 
        0.028898161702210566`, 0.02847318581626224`, 0.028183931461959796`, 
        0.02797889918773`, 0.027829246954131182`, 0.027717773274013376`, 
        0.027633713815890384`, 0.0275700828728542`, 0.027522228539703177`, 
        0.027487008892763978`, 0.027462305327609716`, 0.027446729550843825`, 
        0.02743945377078602`}, {\(-0.0011616467194812904`\), \
\(-0.011359976308002059`\), \(-0.0973623565608614`\), 0.08164747465253269`, 
        0.04603611274888002`, 0.03762837146578047`, 0.03403032840942095`, 
        0.0320994461310514`, 0.03092767522700481`, 0.030159339104145318`, 
        0.02962838171475821`, 0.02924776173778119`, 0.028967951976857188`, 
        0.028759012434494233`, 0.02860201177794952`, 0.028484590703193383`, 
        0.028398527084361046`, 0.028338339728560258`, 0.02830046670255373`, 
        0.02828279536948435`}, {\(-0.0006420518451083057`\), \
\(-0.00539858074020513`\), \(-0.021203462140635378`\), \
\(-0.13934766601665496`\), 0.10365958246695989`, 0.054748347137503865`, 
        0.04300190394527121`, 0.03788808497799296`, 0.035100805452619`, 
        0.03338670717648904`, 0.03225063817174626`, 0.03145933704698037`, 
        0.030889467675928234`, 0.030470308434457378`, 0.030158860403987103`, 
        0.02992787043462811`, 0.02975961087021424`, 0.029642461636223045`, 
        0.029568963678939703`, 
        0.02953472749522147`}, {\(-0.00041176839536998986`\), \
\(-0.0032597579689356386`\), \(-0.01071952968904402`\), \
\(-0.03178389531707594`\), \(-0.18346203084698878`\), 0.12698556255364582`, 
        0.06414614259330105`, 0.04891781542107048`, 0.04222435825379591`, 
        0.038543734025627344`, 0.0362635173805268`, 0.03474414224871943`, 
        0.03368301499869087`, 0.032919503476349705`, 0.03236124933125371`, 
        0.03195209552657456`, 0.0316566343841138`, 0.03145219094783877`, 
        0.031324453306752015`, 
        0.03126508986845014`}, {\(-0.00028964271628679073`\), \
\(-0.0022239618443132144`\), \(-0.006779113516673234`\), \
\(-0.016663113928629885`\), \(-0.04310487402819928`\), \
\(-0.23041910297631552`\), 0.15201863619533854`, 0.07436881618606858`, 
        0.05545464458216132`, 0.04709552792129654`, 0.04247680350516332`, 
        0.039605624067549874`, 0.0376900596823512`, 0.03635476333468099`, 
        0.035400298782937385`, 0.034712140340037057`, 0.03422106363102921`, 
        0.03388409837851069`, 0.03367472443830148`, 
        0.0335777249736706`}, {\(-0.00021719146156720916`\), \
\(-0.0016384146243432357`\), \(-0.004796170751138911`\), \
\(-0.010854904205068946`\), \(-0.023168764221664293`\), \
\(-0.05531484068210868`\), \(-0.28112662802154137`\), 0.17927828060625658`, 
        0.08563310269792332`, 0.06275614540259894`, 0.05261643084941813`, 
        0.04700267942630112`, 0.04351205733957655`, 0.04118911148830996`, 
        0.03958099247038945`, 0.03844751572283139`, 0.037651570196660974`, 
        0.03711150661779671`, 0.03677840127036552`, 
        0.036624713738803744`}, {\(-0.0001707854303276708`\), \
\(-0.0012740335796719673`\), \(-0.003639682785565349`\), \
\(-0.007873632409117867`\), \(-0.015421112941297188`\), \
\(-0.030301153705477996`\), \(-0.06864923242720172`\), \(-0.3367539890188786`\
\), 0.20944991552562173`, 0.09824346452500907`, 0.0710365444329577`, 
        0.05896573204466466`, 0.05228542074128743`, 0.048143418077480446`, 
        0.045405976692476015`, 0.043536706636960576`, 0.042252641055264606`, 
        0.041394428692673346`, 0.04087025500853836`, 
        0.040629725377534`}, {\(-0.00013937422515757008`\), \
\(-0.0010319519247542369`\), \(-0.0029016685519478265`\), \
\(-0.006105018569824097`\), \(-0.011400025815043298`\), \
\(-0.020515518896651742`\), \(-0.03819733852626854`\), \
\(-0.08343497689888336`\), \(-0.39884937487284106`\), 0.2434591143199534`, 
        0.1126255136957813`, 0.08060563126469336`, 0.06640937683717232`, 
        0.05857511651984308`, 0.05374957896400055`, 0.05060178059662147`, 
        0.048504816369052364`, 0.04713184676954703`, 0.04630424048197999`, 
        0.0459272149061554`}, {\(-0.00011722475816816126`\), \
\(-0.0008634099081389706`\), \(-0.0024014260633821926`\), \
\(-0.004960348715556035`\), \(-0.0089914179334242`\), \
\(-0.015404675734709468`\), \(-0.026239658010951995`\), \
\(-0.047064044441082004`\), \(-0.10012169485143636`\), \(-0.4695288817647681`\
\), 0.28259499476718813`, 0.1293874244033799`, 0.09191795552727536`, 
        0.0753476152465847`, 0.06625752269573744`, 0.06072556412105758`, 
        0.057200111224244544`, 0.054957313559356916`, 0.05362953929013312`, 
        0.053030553812386666`}, {\(-0.00010112247360243876`\), \
\(-0.0007419861865178031`\), \(-0.0020477062215252446`\), \
\(-0.004175842535645177`\), \(-0.007420503166385873`\), \
\(-0.012327546726896468`\), \(-0.01997431628148604`\), \
\(-0.032756553366753406`\), \(-0.057197475224030764`\), \
\(-0.1193402337397619`\), \(-0.5517881130972446`\), 0.3287190971233165`, 
        0.14942889022811967`, 0.10566333850586158`, 0.08640427710476072`, 
        0.07595099174334236`, 0.06972405413156958`, 0.06592469426200663`, 
        0.06373183293250255`, 
        0.06275592431545368`}, {\(-0.00008915347636444533`\), \
\(-0.0006523254745584571`\), \(-0.001790015736021272`\), \
\(-0.0036167831269479926`\), \(-0.00633821536831461`\), \
\(-0.010313961633474459`\), \(-0.01619496020867402`\), \
\(-0.025253378624654422`\), \(-0.04030798239652584`\), \(-0.0690251336817831`\
\), \(-0.14200452673229752`\), \(-0.6500406868282148`\), 0.3846372362691915`, 
        0.17414148548852376`, 0.12293960918316224`, 0.100603594051815`, 
        0.08870643395951067`, 0.08189833118252457`, 0.07811285553102777`, 
        0.0764606101678888`}, {\(-0.00008012324420106699`\), \
\(-0.0005850120782108702`\), \(-0.0015984727399069418`\), \
\(-0.0032078450608101004`\), \(-0.005565305699078543`\), \
\(-0.008925714931198122`\), \(-0.013722595871933923`\), \
\(-0.02073159406624833`\), \(-0.03146183602763142`\), \(-0.04925232054758216`\
\), \(-0.08318214208673969`\), \(-0.16949393339613797`\), \
\(-0.7710996674148258`\), 0.45480036011645714`, 0.20580208220241117`, 
        0.14560647501107343`, 0.11975021752335985`, 0.10646107213453891`, 
        0.09948958663460393`, 
        0.09653424775583087`}, {\(-0.00007325818899287087`\), \
\(-0.0005340286597241991`\), \(-0.0014544788512073784`\), \
\(-0.0029040590721518015`\), \(-0.005001080106298036`\), \
\(-0.007937296237448117`\), \(-0.012024278562187046`\), \
\(-0.017785284271505476`\), \(-0.02615185689915697`\), \
\(-0.038933841544336434`\), \(-0.060135847995177114`\), \
\(-0.10065278324377022`\), \(-0.20399804733439034`\), \
\(-0.9261045444393188`\), 0.546737556862238`, 0.2484161029566828`, 
        0.1770870216026132`, 0.1473465358427942`, 0.1332193518776888`, 
        0.12750415260611753`}, {\(-0.00006804318658957261`\), \
\(-0.000495408675911905`\), \(-0.0013460177583784559`\), \
\(-0.002677265781224719`\), \(-0.004585254207593828`\), \
\(-0.00722191930829689`\), \(-0.010825808317959444`\), \
\(-0.015779339820651495`\), \(-0.022721563117699822`\), \
\(-0.0327891092558631`\), \(-0.04819230761918337`\), \
\(-0.07382966712286523`\), \(-0.12304887870290777`\), \(-0.24922183446982127`\
\), \(-1.1346429582533102`\), 0.6742984022124144`, 0.30975165786914727`, 
        0.2244522098912326`, 0.1912047664676305`, 
        0.1788212263225075`}, {\(-0.0000641288570472542`\), \
\(-0.0004664826626420767`\), \(-0.001265125716099333`\), \
\(-0.0025092412376601677`\), \(-0.00428010798299294`\), \
\(-0.006703845220909343`\), \(-0.009973455443605986`\), \
\(-0.014387909859248567`\), \(-0.020424438946776483`\), \
\(-0.028880787645636282`\), \(-0.04117957812506494`\), \
\(-0.060097337372698116`\), \(-0.09181072536815305`\), \
\(-0.15320710494336132`\), \(-0.3119813205514533`\), \
\(-1.4346974738797476`\), 0.8660829097312647`, 0.4071294777000004`, 
        0.3050555116883248`, 
        0.27305057883882167`}, {\(-0.00006127665935547358`\), \
\(-0.00044543882959059136`\), \(-0.0012064605972165242`\), \
\(-0.0023879795408908813`\), \(-0.004061415523167904`\), \
\(-0.006336079170052727`\), \(-0.009376151328150749`\), \
\(-0.013429720594345709`\), \(-0.01888003512873908`\), \
\(-0.02634042746934856`\), \(-0.03684184760200277`\), \(-0.05223602212379411`\
\), \(-0.07616562050228008`\), \(-0.11679870430477828`\), \
\(-0.19662982687260852`\), \(-0.4063528297663731`\), \
\(-1.9109511695005625`\), 1.1922681349445385`, 0.5886604936706183`, 
        0.47599843256284824`}, {\(-0.00005932555445431731`\), \
\(-0.00043105948037481997`\), \(-0.0011664633538623894`\), \
\(-0.0023055892835952066`\), \(-0.003913551399000797`\), \
\(-0.006089070963373769`\), \(-0.008978531655807028`\), \
\(-0.012799407750409244`\), \(-0.01788027107123791`\), \
\(-0.024731802790703382`\), \(-0.03417953234335988`\), \
\(-0.04762896289011643`\), \(-0.06764217283043483`\), \(-0.09934179389054804`\
\), \(-0.15441257301551295`\), \(-0.2655868696937658`\), \
\(-0.5668769706733167`\), \(-2.7986009906621314`\), 1.883474741083865`, 
        1.0568566429033417`}, {\(-0.00005817164916122752`\), \
\(-0.0004225615266536118`\), \(-0.0011428594950165644`\), \
\(-0.0022570755604075093`\), \(-0.0038267574248521054`\), \
\(-0.005944695415450145`\), \(-0.008747433150109472`\), \
\(-0.012435797537819171`\), \(-0.01730925752545888`\), \
\(-0.023825351493068202`\), \(-0.03270710642425657`\), \
\(-0.04514829674358455`\), \(-0.06323379498011478`\), \(-0.09087984877744168`\
\), \(-0.1361955742677868`\), \(-0.2184447398466037`\), \
\(-0.3941643021813384`\), \(-0.9070782701271088`\), \(-5.0863407710055695`\), 
        4.407563610218306`}, {\(-0.0009654560549317881`\), \
\(-0.008893877156561565`\), \(-0.05119178825104622`\), 0.13567889643053227`, 
        0.05350458991459994`, 0.04083473643861383`, 0.03591167021083946`, 
        0.0333800409270076`, 0.03187938800082717`, 0.030909612485063274`, 
        0.03024590668927896`, 0.029773331864865894`, 0.02942761508309114`, 
        0.029170390945833742`, 0.02897762889471517`, 0.028833752672530893`, 
        0.02872845645032773`, 0.02865489814222896`, 0.028608644739932614`, 
        0.02858707197220078`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(b = {0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 
          0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , \ 0. , 
          0. , \ \ 0.876306};\)\), "\[IndentingNewLine]", 
    \(LinearSolve[m, b]\  (*\ 
      This\ is\ the\ value\ of\ g[s[j]]\ *) \)}], "Input"],

Cell[BoxData[
    \({111.30630393261791`, 21.59605036632878`, 9.625242317950752`, 
      5.653326790880356`, 3.8247354266764675`, 2.824510059547165`, 
      2.2164563269580975`, 1.8202040052085977`, 1.5496903054020024`, 
      1.359556638169722`, 1.2241703639116703`, 1.1283979244313531`, 
      1.0632143388094912`, 1.023559755360724`, 1.007443688085064`, 
      1.0160404486830756`, 1.0553176821232837`, 1.1420343151404266`, 
      1.3309487355036937`, 2.0428438457946063`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{129, Automatic}, {39, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 3183, 57, 779, "Input"],
Cell[4925, 110, 10873, 166, 1436, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15835, 281, 312, 5, 75, "Input"],
Cell[16150, 288, 489, 7, 56, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

